/*
 * Decompiled with CFR 0.152.
 */
package kk;

import java.awt.Color;
import java.awt.geom.Point2D;
import kk.Knoboter;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Brexit
extends Knoboter {
    static final int END = 0;
    static final int CIRCLE = 1;
    static final int APPROACH = 2;
    static final int RANDOM = 4;
    int mode = 4;
    int count = 0;
    int takt = 0;
    double direction = 1.0;
    double randomdirection = 0.0;
    double gunTurnAmt;
    double radarWidth = 20.0;
    double lastDistance = 10000.0;
    double lastTeammate = -180.0;
    String trackName = null;
    boolean infocus = false;
    boolean turning = false;
    boolean scanning = false;
    boolean attacking = false;
    boolean backwards = false;
    int hitcount = 0;
    Color normalcolor = Color.black;

    public void run() {
        this.trackName = null;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAllColors(this.normalcolor);
        while (this.mode != 0) {
            if (this.mode == 4 || this.count > 4) {
                this.setScanning(true);
                this.setAttack(null);
                this.setRandom();
                this.turnRadarLeft(360.0);
                this.count = 0;
                continue;
            }
            if (this.count == 0) {
                this.turnRadarLeft((this.radarWidth *= -1.0) / 2.0);
            } else {
                this.turnRadarLeft(this.radarWidth *= -1.0);
            }
            ++this.count;
        }
    }

    void syncRadar() {
        this.turnRadarRight(this.normalRelativeAngle(this.getGunHeading() - this.getRadarHeading()));
    }

    void optimizedTurn(double opponentBearing, double opponentVelocity, double opponentDistance) {
        double angle = this.normalRelativeAngle(opponentBearing);
        if (this.mode == 1) {
            if (this.backwards) {
                this.setTurnRight(this.normalRelativeAngle(angle - 180.0));
            } else {
                this.setTurnRight(angle);
            }
        } else if (this.abs(angle) > 90.0) {
            this.backwards = true;
            this.setTurnRight(this.normalRelativeAngle(angle - 180.0));
        } else {
            this.backwards = false;
            this.setTurnRight(angle);
        }
    }

    void optimizedMove(double amount) {
        if (this.backwards) {
            this.setBack(amount);
        } else {
            this.setAhead(amount);
        }
    }

    @Override
    void setAttack(String name) {
        if (name != null && !this.attacking) {
            this.trackName = name;
            this.attacking = true;
            this.setRadarColor(this.normalcolor);
            this.out.println("Tracking " + this.trackName);
        } else if (this.attacking) {
            this.trackName = null;
            this.attacking = false;
            this.setRadarColor(Color.red);
        }
    }

    void setRandom() {
        if (this.mode != 4) {
            this.mode = 4;
            this.setRadarColor(this.normalcolor);
        }
    }

    void setApproach() {
        if (this.mode != 2) {
            this.mode = 2;
            this.setRadarColor(Color.blue);
        }
    }

    void setCircle() {
        if (this.mode != 1) {
            this.mode = 1;
            this.setRadarColor(Color.yellow);
        }
    }

    void setScanning(boolean b) {
        if (b && !this.scanning) {
            this.scanning = true;
            this.setRadarColor(Color.green);
        } else if (this.scanning) {
            this.scanning = false;
            this.setRadarColor(this.attacking ? Color.red : this.normalcolor);
        }
    }

    void setShoot(boolean b) {
        if (b) {
            this.setGunColor(Color.red);
        } else {
            this.setGunColor(this.normalcolor);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.count = 0;
        String name = e.getName();
        double energy = e.getEnergy();
        double myenergy = this.getEnergy();
        double distance = e.getDistance();
        double velocity = e.getVelocity();
        double myvelocity = this.getVelocity();
        double bearing = e.getBearing();
        double heading = e.getHeading();
        double myheading = this.getHeading();
        double mygunheading = this.getGunHeading();
        boolean teammate = this.isTeammate(name);
        if (distance < 40.0 && this.mode == 2) {
            if (bearing > -90.0 && bearing <= 90.0) {
                this.setBack(5.0);
            } else {
                this.setAhead(5.0);
            }
        }
        if (teammate) {
            this.optimizedTurn(bearing - 180.0, velocity, distance);
            return;
        }
        double gunbearing = this.abs(this.normalRelativeAngle(bearing + myheading - mygunheading));
        double movefactor = this.abs(this.normalRelativeAngle(mygunheading + heading)) / 18.0 * this.abs(velocity) / 8.0;
        if (distance <= 75.0 && gunbearing <= 4.0 || distance < 150.0 && gunbearing <= 2.0 && movefactor < 16.0) {
            this.smartFire();
        }
        if (this.trackName == null) {
            this.setAttack(null);
            this.setAttack(name);
            this.lastDistance = distance;
            this.setApproach();
            this.out.println("Tracking " + this.trackName);
        } else if (distance < this.lastDistance || energy < myenergy) {
            this.lastDistance = distance;
            if (!name.equals(this.trackName)) {
                this.setAttack(null);
                this.setAttack(name);
                this.out.println("Better target detected, now tracking " + this.trackName);
            }
        }
        if (name.equals(this.trackName)) {
            double safedistance = this.getOthers() <= 1 ? 75.0 : 350.0;
            this.lastDistance = distance;
            this.maybeTrackRobot(e, false);
            if (distance > safedistance) {
                this.setApproach();
                if (this.getDistanceRemaining() < 1.0) {
                    double miss = (int)distance % 50 < 25 ? 42.0 : -42.0;
                    this.optimizedTurn(bearing - this.direction * miss, velocity, distance);
                    this.optimizedMove(50.0);
                }
            } else if (distance < 55.0) {
                this.optimizedTurn(bearing, velocity, distance);
                this.optimizedMove(-25.0);
            } else {
                this.setCircle();
                if (this.getDistanceRemaining() < 1.0) {
                    this.optimizedTurn(bearing - 90.0 * this.direction, velocity, distance);
                    this.optimizedMove(this.direction * 45.0);
                }
            }
        }
        this.lastDistance = distance;
    }

    @Override
    public synchronized void maybeTrackRobot(ScannedRobotEvent e, boolean priority) {
        double predictedY;
        double predictedX;
        double absoluteBearingRadians;
        double y;
        double x;
        double enemyDistance;
        String enemyName;
        block6: {
            enemyName = e.getName();
            if (this.trackName == null) {
                this.trackName = enemyName;
                this.setRadarColor(Color.red);
                this.out.println("Neues Opfer: " + enemyName);
            } else if (priority && !enemyName.equals(this.trackName)) {
                this.trackName = enemyName;
                this.out.println("Neues Hauptopfer: " + enemyName);
                this.setRadarColor(Color.red);
            }
            double enemyBearing = e.getBearing();
            double enemyBearingRadians = e.getBearingRadians();
            enemyDistance = e.getDistance();
            double enemyHeadingRadians = e.getHeadingRadians();
            double enemyVelocity = e.getVelocity();
            x = this.getX();
            y = this.getY();
            double headingRadians = this.getHeadingRadians();
            double bulletPower = Math.min(3.0, this.getEnergy());
            absoluteBearingRadians = headingRadians + enemyBearingRadians;
            double enemyX = x + enemyDistance * Math.sin(absoluteBearingRadians);
            double enemyY = y + enemyDistance * Math.cos(absoluteBearingRadians);
            double deltaTime = 0.0;
            double battleFieldHeight = this.getBattleFieldHeight();
            double battleFieldWidth = this.getBattleFieldWidth();
            predictedX = enemyX;
            predictedY = enemyY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(x, y, predictedX, predictedY))) break block6;
                predictedY += Math.cos(enemyHeadingRadians) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeadingRadians) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - x, predictedY - y));
        double gunTurnRadians = Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians()));
        if (enemyDistance < 60.0 && this.abs(gunTurnRadians) < 0.25 || enemyDistance < 100.0 && this.abs(gunTurnRadians) < 0.1 || enemyDistance < 250.0 && this.abs(gunTurnRadians) < 0.05 || this.abs(gunTurnRadians) < 0.025) {
            this.smartFire();
        }
        if (enemyName.equals(this.trackName)) {
            this.setTurnGunRightRadians(gunTurnRadians);
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearingRadians - this.getRadarHeadingRadians())));
        }
    }

    @Override
    public void smartFire() {
        this.setShoot(true);
        if (this.getGunHeat() == 0.0) {
            this.setFire(Math.min(3.0, this.getEnergy()));
        }
        this.setShoot(false);
    }

    public void onHitRobot(HitRobotEvent e) {
        double bearing = e.getBearing();
        String name = e.getName();
        if (name.equals(this.trackName)) {
            return;
        }
        if (bearing > -90.0 && bearing < 90.0) {
            this.back(15.0);
        } else {
            this.ahead(15.0);
        }
        this.direction *= 1.0;
        if (this.isTeammate(name)) {
            return;
        }
        this.setAttack(null);
        this.setAttack(name);
        this.setApproach();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName().equals(this.trackName)) {
            this.setAttack(null);
            this.setRandom();
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
        if (e.getBearing() > -90.0 && e.getBearing() <= 90.0) {
            this.back(15.0);
        } else {
            this.ahead(15.0);
        }
        this.direction *= -1.0;
        this.clearAllEvents();
    }

    public void onWin(WinEvent e) {
        this.clearAllEvents();
        this.stop();
        for (int i = 0; i < 3; ++i) {
            this.turnRight(360.0);
        }
        this.mode = 0;
    }

    public double normalRelativeAngle(double angle) {
        double fixedAngle;
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        for (fixedAngle = angle; fixedAngle <= -180.0; fixedAngle += 360.0) {
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    @Override
    public double abs(double x) {
        return x < 0.0 ? -x : x;
    }
}

