package ws2006.Team2;

/**
 * @author Thorsten Stadtfeld
 * @author Steffen Steinbrecher
 * @author Jzef Fehr
 * @author Stefan Reitz
 * 
 * created 2007-02-12 - 2007-02-16
 * 
 */

import robocode.*;

/**
* This robot is the "droid" of the team. It handles as droid until the leading
* robot dies. Then this robot handles the same way as the leading bot did.
*/
public class DroidBot extends TeamRobot {

	// enemy object
	private EnemyBot enemy;
	// direction for moving
	private int direction = 1;
	//indicates whether the leader robot is alive
	private boolean teamComplete = true;
	private	int count = 0;
	private double gunTurnAmt;
	
	/**
	 * run : Main method of the TeamRobot object
	 * @param  
	 * @return
	 */	
	public void run() {
		// creating new enemy instance
		this.enemy = new EnemyBot();
		
		// if the robot is alone
		if (teamComplete==false) {
			// set the gun
			setAdjustGunForRobotTurn(true); 
			gunTurnAmt = 10; 
			while (true) 
			{
				out.println(this.enemy.getName());
				turnGunRight(gunTurnAmt);
				count++;
				// turn left if no target has been found after 2 turns
				if (count > 2) 	gunTurnAmt = -10;
				// turn right if no target has been found after 5 turns
				if (count > 5) 	gunTurnAmt =  10;
				//reset the enemy object after 10 trials
				if (count > 11) this.enemy.reset();
				
			}
		}
	}
	
	/**
	 * onMessageReceived : EventHandler of TeamRobot object.
	 * Will be called after receiving a message of a teammate
	 * @param  MessageEvent
	 * @return
	 */
	public void onMessageReceived(MessageEvent e) {
		// get the message (action to do)
		String condition = (String)e.getMessage();
		// switch actions
		if (condition.equals("LeaderBotDied_HoldOnKilling"))  {
			// leader is dead, robot starts killing by its own
			this.teamComplete = false;
			this.enemy.reset();
			out.println("OK I will continue killing the damned machines");
		}
		else {
			 // Stop action has been send (enemy is lost) > hesitate
			 if (condition.equals("stopAction")) { this.stop(); }
			 else {
						// continue moving
						this.resume();
						// parse the message and set enemy information/coordinates
						String message = condition;
						String[] values = message.split ("#");
						this.enemy.setName(values[0]);
						this.enemy.setBearing(Double.parseDouble(values[1]));
						this.enemy.setDistance(Double.parseDouble(values[2]));
						this.enemy.setEnergy(Double.parseDouble(values[3]));
						this.enemy.setHeading(Double.parseDouble(values[4]));
						this.enemy.setVelocity(Double.parseDouble(values[5]));
						this.enemy.setFirePower(Double.parseDouble(values[6]));
						this.enemy.setX(Double.parseDouble(values[7]));
						this.enemy.setY(Double.parseDouble(values[8]));
						// start attacking the enemy
						attackEnemy();
			}
		}
	}

	
	/**
	 * attackEnemy 
	 * calculates enemy position and turns the gun on it
	 * @param  MessageEvent
	 * @return
	 */
	public void attackEnemy() {

			double dx = this.enemy.getX() - this.getX();
			double dy = this.enemy.getY() - this.getY();
			// Calculate angle to target
			double theta = Math.toDegrees(Math.atan2(dx, dy));
			// Turn gun on target and fire
			turnGunRight(normalRelativeAngle(theta - getGunHeading()));
			fire(3);
	}

	/**
	 * onScannedRobotEvent : EventHandler of TeamRobot object.
	 * Will be called after finding a robot in the scanned range
	 * @param  ScannedRobotEvent
	 * @return
	 */
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		if (this.teamComplete==false)
		{
			// if the stored enemy is the same as the scanned one then abort
			// Very important for tracking!!
			if (!this.enemy.none() && !e.getName().equals(this.enemy.getName())) {
				out.println("Current target: " + this.enemy.getName());
				return;
			}
			// Otherwise -> the robot is an enemy
			// update enemy object
			enemy.update(e);
			
			if (this.enemy.none()) 
			{
				enemy.update(e);
			}
			// reset counter
			count = 0;
			
			// if the target is far away the robot moves toward it
			if (this.enemy.getDistance() > 150) 
			{			
				gunTurnAmt = normalRelativeAngle(this.enemy.getBearing() + (getHeading() - getRadarHeading()));
				setTurnGunRight(gunTurnAmt); 
				setTurnRight(this.enemy.getBearing()); 
				setAhead(this.enemy.getDistance() - 140);
				execute();
				return;
			}
	
			// now the target is near		
			gunTurnAmt = normalRelativeAngle(this.enemy.getBearing() + (getHeading() - getRadarHeading()));
			setTurnGunRight(gunTurnAmt);
			execute();
			// get the fire power of the enemy and increase the own about that + 1 
			// fire 5 times non-stop
			int i = 1;
			if (this.enemy.getFirePower()!=0.0)
			{
				while(i<=5) {
					fire(this.enemy.getFirePower()+1);
					i++;
				}
			}
			else {
				while(i<=5) {
					fire(3);
					i++;	
				}
			}
			execute();
		
			
			// the target is to close, move backwards	
			if (this.enemy.getDistance() < 100) {
				if (this.enemy.getBearing() > -90 && this.enemy.getBearing() <= 90) {
					setBack(40);
					execute();
				} else {
					setAhead(40);
					execute();
				}
			}
			scan();
		}
	}

	
	/**
	 * onHitRobot : EventHandler of TeamRobot object.
	 * Called after the robot has been hit by another 
	 * @param  HitRobotEvent
	 * @return
	 */
	public void onHitRobot(HitRobotEvent e) {
	
		if (this.teamComplete==false) 
		{
			// Set the target
			// set the hitting robot as new enemy 
			enemy.update(e);
	
			//Turn gun on enemy
			gunTurnAmt = normalRelativeAngle(this.enemy.getBearing() + (getHeading() - getRadarHeading()));
			setTurnGunRight(gunTurnAmt);
			setFire(2);
			execute();
			setBack(50);
			execute();
		}
	}

	/**
	 * normalRealativeAngle
	 * Calculates fixed angle from given angle
	 * @param  double > angle
	 * @return double > fixed angle
	 */	
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle <= -180) {
			fixedAngle += 360;
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}
	

	/**
	 * onHitByBullet : EventHandler of TeamRobot object.
	 * Called after the robot has been hit by a bullet. The move out the scanning range.
	 * @param  HitByBulletEvent
	 * @return
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		if (this.teamComplete==false)
		{	
			// move out of scanning range
			doMovement();
		}
		else scan();
			
	}
	
	/**
	 * doMovement : Method
	 * performs some action in order to move away from the scanning range of enemies
	 * @param  
	 * @return
	 */	
	public void doMovement() {
			this.direction *=-1;
			setAhead(direction*200);		
			setTurnRightRadians(this.enemy.getBearing() - (Math.PI/2));
			execute();
			
	}
	
	
}
