// Team Boller
package ss2007.Team2;
import robocode.*;
import robocode.util.*;
import java.io.*;
import java.awt.Color;
import java.awt.geom.*;

/**
 * Vernichter - a robot by (Kigh)
 */
public class Vernichter extends TeamRobot
{
   String chefziel="boller";
   boolean cheflebt=true;

//_____________________RUN_____________________
public void run() {
   //Farben
   setAllColors(Color.white);

   //Das macht er immer
   while(true) {
       turnRadarRight(360);
   }
}

//_______________________on Message________________________
public void onMessageReceived(MessageEvent e) {
   chefziel = (String)e.getMessage();
}

//_____________________onScannedRobot_____________________
public void onScannedRobot(ScannedRobotEvent e) {
	//Gescanntes Ziel ist boller.Chef also weiterscannen
	if (e.getName().equals("boller.Chef")) {
		scan();
	}

	//Chef lebt nichtmehr also auf erstes Ziel feuern
	else if (!cheflebt) {
		BollerZielen(e);
    }
	
	//Chef lebt noch aber hat noch kein Ziel vorgegeben, also feuer frei
    else if (cheflebt && (chefziel.equals("boller"))) {
        BollerZielen(e);
   }
   
	//Chef lebt noch und hat ein Ziel vorgegeben
    else if (cheflebt && (!(chefziel.equals("boller"))) && (e.getName().equals(chefziel))) {
		BollerZielen(e);
   }
   
    //Sonst macht er mit dem Scan weiter
	else {
		scan();
	}
}

//_____________________Zielen_______________________
public void BollerZielen(ScannedRobotEvent e){
	double bulletPower = Math.min(3.0,getEnergy());
	double myX = getX();
	double myY = getY();
	double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
    double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
    double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
    double enemyHeading = e.getHeadingRadians();
    double enemyVelocity = e.getVelocity();
    double deltaTime = 0;
    double battleFieldHeight = getBattleFieldHeight(),battleFieldWidth = getBattleFieldWidth();
    double predictedX = enemyX, predictedY = enemyY;
    while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){
        predictedX += Math.sin(enemyHeading) * enemyVelocity;
        predictedY += Math.cos(enemyHeading) * enemyVelocity;
        if(    predictedX < 18.0
            || predictedY < 18.0
            || predictedX > battleFieldWidth - 18.0
            || predictedY > battleFieldHeight - 18.0){
            predictedX = Math.min(Math.max(17.9, predictedX),battleFieldWidth - 17.9);
            predictedY = Math.min(Math.max(17.9, predictedY),battleFieldHeight - 17.9);
            break;
        }
    }
    double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
    
	//Beschleunigen wenn man wieder von der Wand weg ist
	if (getX() > 30 && getX() < 970 && getY() > 30 && getY() < 970) {
           setMaxVelocity(8.0);
    }
	//Bremsen wenn man zu nah an die Wand kommt
    if (getX() < 30 || getX() > 970 || getY() < 30 || getY() > 970) {
           setMaxVelocity(4.0);
    }
	//Geradeaus fahre
    setAhead(e.getDistance());


	setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
    setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));

       //FEUERSTAERKE BESTIMMEN IN ABHAENGIGKEIT DER DISTANZ
       if ((e.getBearing()>=(-186))&&(e.getBearing()<=-176)){
           if (getGunHeat() == 0) setFire(3);
       }
       else if (e.getDistance()<200) {
            if (getGunHeat() == 0) setFire(3);
       }
       else if (e.getDistance()<300) {
            if (getGunHeat() == 0) setFire(2);
       }
       else if (e.getDistance()<360) {
           if (getGunHeat() == 0) setFire(1);
       }
       else if (e.getDistance()<500) {
           if (getGunHeat() == 0) setFire(0.5);
       }
	   //auf fast stehende Ziele immer feuern, egal wie weit sie weg sind
       else if (e.getVelocity() <= 0.1) if (getGunHeat() == 0) setFire(1);
   }

//_____________________HIT WALL_______________________
public void onHitWall(HitWallEvent e) {
    setMaxVelocity(8.0);
    turnRight(e.getBearing()-120);
	setAhead(50);
}

//_____________________HIT ROBOT_______________________
public void onHitRobot(HitRobotEvent e) {
   setTurnLeft(60);
   back(80);
}

//______________________onHitByBullet_____________________
public void onHitByBullet(HitByBulletEvent e) {
    if(e.getName().equals("boller.Chef"))
    Nachricht("stopefant");
 }

//_____________________ON WIN_____________________
public void onWin(WinEvent e) {
	out.println("SIEG!");
}

//_______________________Nachricht________________________
public void Nachricht(String msg){
   try{
       broadcastMessage(msg);
       out.println("Nachricht: '" + msg + "' bergeben");
   }
   catch (IOException ex) {
       out.println("Unable to send order: " + ex);
   }
}

//______________________onRobotDeath_____________________
   // Wenn ein Roboter VERNICHTET wurde, Anzahl verringern
   public void onRobotDeath(RobotDeathEvent e){
        if (e.getName().equals("boller.Chef")) {
			cheflebt=false;
			chefziel="boller";
       }
   }

 //_____________________Programmende_____________________
}
