// Team FlitschFlatsch
package ss2007.Team3;
import robocode.*;
import robocode.util.*;
import java.lang.*;
import java.awt.Color;
import java.awt.geom.*;
import java.io.*;

/**
 * SledgeHammer - a robot by: 
 * Idea's: Andre Sres, Florian Peifer, Andreas Fritzler
 * Implemenation & Comments: Andre Sres
 */
public class SledgeHammer extends TeamRobot
{
	/**
	 * run: SledgeHammer's default behavior
	 */
	
	/**
	 * Die run Methode bestimmt das Verhalten des Roboter's solange kein Ereigniss eingetreten ist
	 */
	
	static int trefferKassiert=0;
	String trefferKassiertvon=new String("");
	String vorherKassiertvon=new String("");

	public void run() {
		setBodyColor(new Color(139,134,75));
		setRadarColor(new Color(85,107,47));
		setGunColor(new Color(0,0,0));
		setBulletColor(new Color(255,255,255));
		turnLeft(getHeading() % 90);
		if(getHeading()==270||getHeading()==90)wegberechnung(getX(),getHeading());
		if(getHeading()==0||getHeading()==180) wegberechnung(getY(),getHeading());
		turnGunRight(90);
		turnRight(90);
		if(getOthers()<=2){
			setAdjustGunForRobotTurn(true);
		}
		
		//Solange noch mehrere Gegner im Spiel sind waehle die Standardtaktik
		while(getOthers()>2) { 
			standardroutine();
			
		}
	
		//Sobald nur noch zwei Gegner uebrig sind gehe zur ueber zur Verfolgungsstrategie
		while(getOthers()<=2){ 
			verfolgungsroutine();
		}
		
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if(!isTeammate(e.getName())){
			if(getOthers()<=2){
				double bearingFromGun = winkelBerechnung(e.getBearing() + getHeading() - getGunHeading());
  				vorzielen(e,3);
  				verfolgung(e.getBearing(),e.getDistance());
			}
			if(getOthers()>2){
			
				double feuerstaerke=0;
				if(e.getDistance()<=600){
					feuerstaerke=1;
				}
				if((e.getDistance()>200)&&(e.getDistance()<400)){
					feuerstaerke=2.0;
				}
				if(e.getDistance()<200){
					feuerstaerke=3.0;
				}
				setAdjustGunForRobotTurn(true);
				vorzielen(e,feuerstaerke);
				setAdjustGunForRobotTurn(false);
			} 
			else;
			
			
			
		}
		else;
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		// Wenn mehr als 2 Gegner im Spiel sind
		if(getOthers()>2){
			if(!isTeammate(e.getName())){
				vorherKassiertvon=trefferKassiertvon;
				trefferKassiertvon=e.getName();
				//merke Dir wer auf Dich geschossen hat und falls er es wiederholt tut merke dir wie oft
				if(trefferKassiertvon.equals(vorherKassiertvon)){
					trefferKassiert++;			
				}
				else {
					trefferKassiert=0;
				}
				//Wenn Du mehr als 4 Schuesse von selben Gegner kassierst, siehe zu dass Du Land gewinnst!!!
				if(trefferKassiert>=4){
					if(e.getBearing()!=0){
						turnLeft(getHeading()%90);
						ahead(100);
					}
					else ahead(100);
				}
				else;
			}
		}
		if(getOthers()<=2){
			setTurnLeft(winkelBerechnung(90-e.getBearing()));
			setAhead(50);
		}
		// Wenn Dich ein Teammitglied anschiesst, sende ihm eine Nachricht
		if(isTeammate(e.getName())){
			try{
				broadcastMessage("STOP FIRE");
			}
			catch(IOException ex){
				out.println("Fehler beim Senden der Nachricht von"+getName());
			}		
		}		
	}
	
	public void onHitRobot(HitRobotEvent e) {
		//Wenn weniger als 2 Gegner im Spiel sind
		if(getOthers()<=2){
			// und der Gegner mehr als 20 Punkte weniger Energie als Du hat, mach Ihn fertig! 
			if(e.getEnergy()<getEnergy()-20){
				setTurnGunRight(winkelBerechnung(e.getBearing()+getHeading()-getGunHeading()));
				fire(3);
			}
			else;
		}
		if(getOthers()>2&&!isTeammate(e.getName())){
			if(e.getEnergy()<getEnergy()-20){
				setTurnGunRight(winkelBerechnung(e.getBearing()+getHeading()-getGunHeading()));
				fire(3);
			}
			
			else {
				if (e.getBearing() > -90 && e.getBearing() < 90) {
					back(100);
				} 
				else {
					ahead(100);
				}
				
			}
		}
	}
	
	// Im Falle eines Gewinnes, wechsle die Farbe auf Gold und drehe den Koerper nach rechts, sowie die Kanone nach links;
	public void onWin(WinEvent e) {  
		for (int i = 0; i <10; i++) {  
			setBodyColor(new Color(255,215,0));
			setGunColor(new Color(255,215,0));
			setRadarColor(new Color(255,215,0));
			turnRight(20);
			turnGunLeft(20);
		}
	}
	//Falls Du eine Nachricht mit "STOP FIRE" bekommen solltest, höre auf zu schiessen
	public void onMessageRecieved(MessageEvent e){
		if(e.getMessage().equals("STOP FIRE")){
			run();
		}
	}
	
	// Drehe Deine Kanone immer Senkrecht zur Laufrichtung
	public void standardroutine(){
		if(getHeading()==270){
			turnGunLeft(getGunHeading()%360);
		}
		if(getHeading()==0){
			turnGunLeft((getGunHeading()%360)+90);
		}
		if(getHeading()==90){
			turnGunLeft((getGunHeading()%360)+180);
		}
		if(getHeading()==180){
			turnGunLeft((getGunHeading()%360)+270);
		}
				
		if(getHeading()==270||getHeading()==90){
			wegberechnung(getX(),getHeading());
			turnRight(90);
		}
		if(getHeading()==0||getHeading()==180){ 
			wegberechnung(getY(),getHeading());
			turnRight(90);
		}
		
		
	}
	//Verfolgungsroutine bestimmt das Standardverhalten, wenn nur noch 1 Gegner uebrig ist
	public void verfolgungsroutine(){ 
		setAdjustGunForRobotTurn(true);
		turnRadarRight(360);
	}
	// Roboter verfolgt den Gegner bzw. uebernimmt dessen Laufverhalten
	public void verfolgung(double bearing, double distance){ 
		
		setTurnGunRight(winkelBerechnung(bearing+getHeading()-getGunHeading())); //Drehe Kanone in Richtung Gegner
  		setTurnRadarRight(winkelBerechnung(getGunHeading()-getRadarHeading()));//Drehe Radar in Richtung des Gegner
  		setTurnRight(bearing);// Fahre in Anhaegigkeit von der Linie Deines Gegners
 
  		if(distance > 90) { // Bist du zu weit weg fuehre naeher ran
   			setAhead(distance - 85);
  		}
  		
  		if (distance < 80) { // Bist du zu nah, fahre ein stueck zurueck
   			setBack(15);
  		}
	}
	/*
	***************************************************Hilsfmethoden**************************************************|
	*/
	//Methode zur Berechnung des Laufweges
	// Berechnet den Laufweg im Spielfeld an der Wand entlang, ohne jedoch diese zu berühren
	public void wegberechnung(double point, double heading){
		
		if(heading==270|| heading==90){
			if(heading==270){
				ahead(point-36);
			}
			if(heading==90){
				ahead((getBattleFieldWidth()-point)-36);
			}
		}
		if(heading==180||heading==0){
			if(heading==180){
				ahead(point-36);
			}
			if(heading==0){
				ahead((getBattleFieldHeight()-point)-36);
			}
		}
	}
	
		
	// Berechne aus gegebenem Winkel einen Winkel der zwischen -180 Grad und 180 Grad ist.
	public double winkelBerechnung(double winkel) {
		if(winkel>-180&&winkel<=180) return winkel;
		double hilfswinkel = winkel;
		while (hilfswinkel <= -180)
			hilfswinkel += 360;
		while (hilfswinkel > 180)
			hilfswinkel -= 360;
		return hilfswinkel;
		
	}
	//Methode zur Bestimmung des Zukuenftigen Standortes des Gegners
	public void vorzielen(ScannedRobotEvent e,double feuerstaerke){
		//Deine Koordinaten	
		double meinX=getX();
		double meinY=getY();
		//Winkel zu Feind in Radianten
		double richtung_zu_feind=e.getBearingRadians()+getHeadingRadians();
		//Berechnug des jetztigen Punkt des Feindes
		double feindX= meinX+e.getDistance()*Math.sin(richtung_zu_feind);
		double feindY= meinY+e.getDistance()*Math.cos(richtung_zu_feind);
		double ausrichtung_feind=e.getHeadingRadians();
		double v_feind=e.getVelocity();
		int zeit = 0;
		double naechstes_feindX=feindX;
		double naechstes_feindY=feindY;
		double spielFeldHoehe= getBattleFieldHeight();
		double spielFeldBreite= getBattleFieldWidth();
		//Solange die Distanz groesser als die Geschwindigkeit meines Projektils ist muss ich um einen weiteren Punkt vorhalten
		while((++zeit)*(20.0-3.0*feuerstaerke)<Point2D.Double.distance(meinX, meinY,naechstes_feindX, naechstes_feindY )){
			//Berechnung des zukuenftigen Punkt des Feindes
			naechstes_feindX+=v_feind*Math.sin(ausrichtung_feind);
			naechstes_feindY+=v_feind*Math.cos(ausrichtung_feind);
			if(naechstes_feindX< 18.0 || naechstes_feindY < 18.0 || naechstes_feindX > spielFeldHoehe-18.0|| naechstes_feindY > spielFeldBreite-18.0){
				naechstes_feindX = Math.min(Math.max(17.9,naechstes_feindX),spielFeldBreite-17.9);	
				naechstes_feindY = Math.min(Math.max(17.9,naechstes_feindY),spielFeldHoehe-17.9);
				break;
			}
						
		}
		double dx = naechstes_feindX - meinX;
		double dy = naechstes_feindY - meinY;
		double theta = Utils.normalAbsoluteAngle(Math.atan2(dx, dy));
		turnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
		fire(feuerstaerke);		
	}	
}
//Ende
