package kk;
import robocode.*;
import java.awt.Color;

/**
 * Vogelgrippe, based on Tracker+Spinbot by Mathew Nelson
 * Author: Klaus Knopper
 * 
 * Changes:
 * - Does not track teammates
 * - When hit by a bullet, moves away orthogonally from fire source
 * 
 */

public class Vogelgrippe extends TeamRobot
{
	static final int END = 0, CIRCLE=1, APPROACH=2, RANDOM=4;
	int mode = RANDOM;
 
 
	int count = 0;          // Keeps track of how long we've been searching for our target
	int takt = 0;
	double direction = 1;
	double randomdirection = 0.0; // direction to move to if we don't have to
	double gunTurnAmt;		// How much to turn our gun when searching
	double radarWidth = 25; // Angle of Radar
	double lastDistance = 10000;
	double lastTeammate = -180;

	String trackName = null;  // Name of the robot we're currently tracking
	boolean infocus   = false;  // Enemy is in Radar's focus
	boolean turning   = false; // Are we currently driving circles?
	boolean scanning  = false; // Are we currently in scan mode?
	boolean attacking = false; // Are we following someone?
	boolean backwards = false; // Are we moving backwards?
	int hitcount = 0;
	Color normalcolor = new Color(0,0,10);

	/**
	 * run: Walzerkoenigs main run function
	 */	
	public void run() {
		trackName = null;	                // Initialize to not tracking anyone
		setAdjustGunForRobotTurn(true);		// Keep the gun still when we turn
		setColors(normalcolor,normalcolor,normalcolor);

		while (mode != END) {
			if(mode == RANDOM || count > 4) {
				setScanning(true); setAttack(null); setRandom();
				turnRadarLeft(360); count = 0; continue;
			} else {
				if(count==0) turnRadarLeft((radarWidth *= -1) / 2);
				else turnRadarLeft(radarWidth *= -1);
			}
			count++;
		}
	} /* end run */
	
	void shoot(double amount){
		setShoot(true);
		if (getGunHeat() == 0){
				double factor=(getEnergy()<10)?0.5:1;
				fire (amount * factor);
		}
		setShoot(false);
	} /* end shoot */
	
	void syncRadar()
	{
		// Lineup Radar with Gun
		turnRadarRight(normalRelativeAngle(getGunHeading() - getRadarHeading()));
	}

	void optimizedTurn(	double opponentBearing,
				double opponentVelocity,
				double opponentDistance)
	{
		double angle = normalRelativeAngle(opponentBearing);
		if(mode == CIRCLE) {
			if(backwards) setTurnRight(normalRelativeAngle(angle-180));
			else setTurnRight(angle);
		} else {
			if(abs(angle) > 90) {
				backwards = true;
				setTurnRight(normalRelativeAngle(angle-180));
			} else {
				backwards = false;
				setTurnRight(angle);
			}
		}
	}
	
	void optimizedMove(double amount) {
		if(backwards) setBack(amount);
		else setAhead(amount);
	}

	// Precalculate where opponent will be if we shoot a bullet at him right now
	void optimizedGunTurn(	double opponentBearing,
				double opponentVelocity,
				double opponentDistance)
	{
		setTurnGunRight(normalRelativeAngle(opponentBearing + getHeading() - getGunHeading()));
		syncRadar();
    }

	void setAttack(String name) {
		if(name != null && !attacking) {
		 trackName = name;
		 attacking = true;
		 setColors(Color.red,Color.red,Color.red);
		 out.println("Tracking " + trackName);
		} else if(attacking) {
		 trackName = null;
		 attacking = false;
		 setColors(normalcolor,normalcolor,normalcolor);
		}
	}
	
	void setRandom() {
		if(mode != RANDOM) {
			mode = RANDOM;
			setColors(normalcolor,normalcolor,normalcolor);
		}
	}

	void setApproach() {
		if(mode != APPROACH) {
			mode = APPROACH;
			setColors(Color.blue,normalcolor,normalcolor);
		}
	}

	void setCircle() {
		if(mode != CIRCLE) {
			mode = CIRCLE;
			setColors(Color.red,normalcolor,normalcolor);
		}
	}
	
	void setScanning(boolean b) {
		if(b && !scanning) {
			scanning = true;
			setColors(Color.green,Color.green,Color.green);
		} else if (scanning) {
			scanning = false;
			setColors(attacking?Color.red:normalcolor,normalcolor,normalcolor);
		}
	}
	
	void setShoot(boolean b) {
		if(b) setColors(null,Color.red,null);
		else setColors(null,normalcolor,null);
	}

	/**
	 * onScannedRobot: Here's the good stuff
	 */	
	public void onScannedRobot(ScannedRobotEvent e) {
    		count = 0;
		String name=e.getName();
		double energy       = e.getEnergy();
		double myenergy     = getEnergy();
		double distance     = e.getDistance();
		double velocity     = e.getVelocity();
		double myvelocity   = getVelocity();
		double bearing      = e.getBearing();
		double heading      = e.getHeading();
		double myheading    = getHeading();
		double mygunheading = getGunHeading();
		boolean teammate    = isTeammate(name);
		
		// Our target is too close!  Back up.
		if (distance < 40 && mode == APPROACH)
		{
			if (bearing > -90 && bearing <= 90)
				{ setBack(5); }
			else
				{ setAhead(5); }
		}
		
		if(teammate) { optimizedTurn(bearing-180, velocity, distance); return; } /* next event */

		/* If a target is right in front of us, just shoot it! */
		double gunbearing = abs(normalRelativeAngle(bearing + myheading - mygunheading));
		double movefactor = abs(normalRelativeAngle(mygunheading+heading))/18 * abs(velocity)/8;
		if(distance <= 75 && gunbearing <= 8.0) shoot(3);
		else if(distance < 150 && gunbearing <= 4.0 && movefactor < 16)   shoot(3); 
		else if(distance < 250 && gunbearing <= 2.0 && movefactor < 8)    shoot(3); 
		else if(distance < 350 && gunbearing <= 1.0 && movefactor < 4)    shoot(2.5);
		else if(gunbearing <= 0.5 && movefactor < 1) shoot(1.1); /* Wasted. */
		
		if(trackName == null)
			{	// New target
				setAttack(null); setAttack(name);		
				lastDistance = distance;
				setApproach();
				out.println("Tracking " + trackName);
			}
		else if(distance < lastDistance || energy < myenergy)
			{
				// This robot is closer, or weaker, and becomes our new target
				lastDistance = distance;
				if(!name.equals(trackName)) {
					setAttack(null); setAttack(name);
					out.println("Better target detected, now tracking " + trackName);
				}
			}
			
		if(name.equals(trackName))
			{
				double safedistance = (getOthers() <= 1) ? 75 : 350;

				// Continue to follow this robot.
				lastDistance = distance;
			
				// Turn Gun and Radar in direction of enemy
				// This is good code.
				optimizedGunTurn(bearing, velocity, distance);
				
				// If our target is too far away, turn and move torward it.
				// If opponents energy is less than mine, follow him.
				if (distance > safedistance) {
					setApproach();
					if(getDistanceRemaining() < 1) {
						double miss = ((int) distance % 50 < 25) ? 42.0 : -42.0;
						/* Turn pod (almost) in direction of enemy */
						optimizedTurn(bearing - direction*miss, velocity, distance);
						optimizedMove(50);
					}
				} else if (distance < 55) {
					optimizedTurn(bearing, velocity, distance);
					optimizedMove(-25);
				} else {
					setCircle();
					// takt++;
					// if(takt > 80) { takt = 0; direction *= -1; }
					if(getDistanceRemaining()<1) {
						optimizedTurn(bearing - 90*direction, velocity, distance);
						optimizedMove(direction * 45);
					}
				}
			}
			
		lastDistance = distance;
		
		// Rescan: See run()
		// scan(); /* Returns immediately to onScannedRobot if robot is still in sight */
	}
	
	/**
	 * onHitRobot:  Collision: Set him as our new target
	 */	
	public void onHitRobot(HitRobotEvent e) {
		double bearing = e.getBearing();
		String name = e.getName();
		
		if(name.equals(trackName)) return; // It's OK.
		
		if (bearing > -90 && bearing < 90)
			back(15);
		else
			ahead(15);
		
		direction *=1 ;

		if(isTeammate(name)) return;
		
		// New Enemy
		setAttack(null); setAttack(name); setApproach();
		
		/* Turn Gun and Radar in direction of enemy. onScannedRobot will make sure that we shoot him. */
		optimizedGunTurn(bearing, 0, 0);
	}
		
	public void onRobotDeath(RobotDeathEvent e) {
		/* Start searching for another target */
		if(e.getName().equals(trackName)) { setAttack(null); setRandom(); }
	}

	public void onHitByBullet(HitByBulletEvent e){
//			double bearing = e.getBearing();
//			double myheading = getHeading();
//			double angle = bearing - getHeading();
//			if (bearing > -90 && bearing <= 90) {
//				optimizedTurn(angle>0?angle-90:angle+90,0,0);
//				ahead(15);
//			} else {
//				optimizedTurn(angle>0?angle-90:angle+90,0,0);
//				back(15);
//			}
	}

//	  if(isTeammate(e.getName())) return; // Don't track Teammates

//	  trackName = e.getName();
//	  infocus = true;
//	  gunTurnAmt = normalRelativeAngle(e.getBearing() + getHeading() - getGunHeading());
//	  setTurnGunRight(gunTurnAmt);		// Try changing these to setTurnGunRight
//	  setTurnRadarRight(normalRelativeAngle(getGunHeading() - getRadarHeading())); // Sync Radar with cannon
//	  if(getDistanceRemaining()==0) escaping=false; // escape complete
//	}
	
	public void onHitWall(HitWallEvent e){
		if (e.getBearing() > -90 && e.getBearing() <= 90)
			back(15);
		else
			ahead(15);
		direction *= -1;
		clearAllEvents();
	}
			
	/**
	 * onWin:  Do a victory dance
	 */	
	public void onWin(WinEvent e) {
		clearAllEvents();
		stop();
		for (int i = 0; i < 3; i++)
		{
		 turnRight(360);
		}
		mode = END;
	}
	
	/**
	 * normalRelativeAngle:  returns angle such that -180<angle<=180
	 */	
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180)
			fixedAngle += 360;
		while (fixedAngle > 180)
			fixedAngle -= 360;
		return fixedAngle;
	}
	
	public double abs(double x) {
		return x<0?-x:x;
	}

}
