package ss2010.FritzFritz;
import robocode.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;
import java.awt.*;

/**
 * HansHans - Droid des Teams FritzFritz
 */

public class ScottScott extends TeamRobot {
	//Definition der Variable gunTurnAmt
	double gunTurnAmt;
	
	public void run() {
	//Farben
		setColors(Color.black,Color.red,Color.yellow);
	}

	/**
	 * onMessageReceived:  Was zu tun ist, wenn der Leader "TomTom" wa schickt
	 */
	public void onMessageReceived(MessageEvent e) {
		// Die geschickte Nachricht als p "Punkt" sichern
		if (e.getMessage() instanceof Navigon) {
			Navigon p = (Navigon) e.getMessage();
			// Berechnung der x un y Wert zum Ziel
			double dx = p.getX() - this.getX();
			double dy = p.getY() - this.getY();
			// Berechnung des Winkels zum Ziel
			double Winkel = Math.toDegrees(Math.atan2(dx, dy));

			// Kanonen zum Ziel drehen
			turnGunRight(normalRelativeAngleDegrees(Winkel - getGunHeading()));
			//Feuern
			fire(3);
		}
	}

	/**
	 * onScannedRobot: Wenn anderer Roboter gescannt wurde 
	 */	
public void onScannedRobot(ScannedRobotEvent e) {
		// Nicht auf Teammitglied schie§en!
		if (isTeammate(e.getName())) {
			return;
		}
		//Wenn die Entfernung mehr als 500 ist
		if (e.getDistance() > 500) {
			gunTurnAmt = normalRelativeAngleDegrees(e.getBearing() + (getHeading() - getRadarHeading()));
			//Den Roboter drehen und auf die gescannte Postion hin fahren
			turnGunRight(gunTurnAmt);  
			turnRight(e.getBearing());
			ahead(e.getDistance() - 400);
			return;
			}
		//Wenn die Entferung weniger als 200 ist
		if (e.getDistance() < 100) 
			{
			//Prfung ob Richtung nach vorne oder hinten ist.	
			if (e.getBearing() > -90 && e.getBearing() <= 90) 
				{
				back(40);
				} else {
					ahead(40);
					}
			}
		fire(3);				
									
	}	

	/**
	 * onHitRobot: Wenn anderer Roboter gerammt wurde  
	 */
public void onHitRobot(HitRobotEvent e) {
		// Wenn er vor uns ist, zurck fahren
		if (e.getBearing() > -90 && e.getBearing() < 90) {
			back(100);
		} // ansonsten, wenn er hinter uns ist, vorwrts fahren
		else {
			ahead(100);
		}
	}

	/**
	 * onHitByBullet: Wenn von einer Kugel getroffen  
	 */
public void onHitByBullet(HitByBulletEvent e) {
		//In die entgegengesetzte Richtng drehen und vorwrts fahren
		turnLeft(90 - e.getBearing());
		ahead(100);
	}

	/**
	 * onHitWall: Wenn eine Mauer gerammt wurde  
	 */
public void onHitWall(HitWallEvent e) {
		//In die entgegengesetzte Richtung drehen und vorwrts fahren
		turnLeft(90 - e.getBearing());
		ahead(100);
	} 			
}		
