package ss2010.Mafia;

import robocode.*;
import java.awt.Color;

public class Corleone extends TeamRobot                 							// <-- Corleone enthält alle Eigenschaften von TeamRobot
{
// --------------------------------------------------- VARIABLEN ----------------------------------------------------------------------------------------------		
	double dist = 100; 																// <-- Gegner wird angegriffen
	double nah  = 200;  															// <-- Gegner wird angegriffen
	double weit = 100;  															// <-- ab hier ist gegner weit
	double entfernung;																	// <-- Die Entfernung des Gegners
	double kanone;																// <-- Variabel für zum fixieren des Gegner
// --------------------------------------------------- METHODEN -----------------------------------------------------------------------------------------------
	
	public void run()
	{          
		// <-- Der Roboter wird lackiert
		setBodyColor(Color.black);
		setGunColor(Color.white);
		setRadarColor(Color.black);
		setScanColor(Color.white);
		setBulletColor(Color.black);
		
		setAdjustGunForRobotTurn(true);				  								// <-- Kanone dreht nicht mehr automatisch mit dem Body 
		turnRadarRightRadians(Double.POSITIVE_INFINITY);  							// <-- Radar dreht endlos   http://robowiki.net/wiki/Radar
	}
	
		
//------------------------------------------------------ EVENTS ------------------------------------------------------------------------------------------------
//------------------------------------------------- ON SCANNED ROBOT -------------------------------------------------------------------------------------------

		
   public void onScannedRobot(ScannedRobotEvent e){
		
	// <-- Wenn das Radar bei ESCOBARR stehen geblieben ist, dreht das Radar weiter
	if (e.getName() .equals("ss2010.Mafia.Escobar") )  
	{
		
		if( e.getDistance() < 100 )													// <-- Es wird geprüft ob Escobarr weniger als 100 Steps entfernt ist
		{
			setTurnLeft(e.getBearing());											// <-- Corleone dreht sich zu Escobarr hin   
			setAhead(-300);															// <-- Roboter fährt 300 Steps zurück
			return;																	// <-- Roboter sucht einen neuen Gegner
		}
		
		else																		// <-- Wenn Escobarr weiter als 100 Steps entfernt ist 
		{
			return;																	// <-- Roboter sucht einen neuen Gegner
		}
	}
	// <-- Radar ist bei einem potentiellen Gegner stehen geblieben
	else 
	{
		entfernung      = e.getDistance();   											// <-- Entfernung des Gegners	
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians()-getGunHeadingRadians()));   // <-- Kanone auf Gegner drehen	
// -------------------------------------------------- Fahrtrichtung --------------------------------------------------------------------------------------------	
		if(getDistanceRemaining()==0)												// <-- Wenn Roboter steht
		{    			
			if(entfernung <= nah )     													// <-- Es wird abgefragt, ob der Gegner weniger oder gleich 200 Steps entfernt ist
			{
				if(Math.random()>.5)												// <-- Es wird geprüft ob die Zufallszahl unter 0.5 ist. Entweder 0 oder 1
					{        														  
						dist*=-1;                 									// <-- Wenn die Zufallszahl kleiner 0.5 war, wird das Vorzeichen von dist umgedreht				
				    }
			 setTurnLeft(90-e.getBearing());         								// <-- Der Roboter dreht 90 Grad minus den Winkel zum Gegner nach links
			 setAhead(dist);     													// <-- Roboter bekommt den Befehl zu fahren. Bei dist=100 vorwärts und bei dist=-100 rückwärts
			 setFire(Math.min(3.0,getEnergy()/10));  								// <-- Roboter schießt. Die Stärke der Kugeln kommt auf die Lebensenergie des Roboters an	
			}  
				
//-------------------------------------------- Gegner ist zu weit entfernt  ---------------------------------------------------------------------------------------
			else 													
			{ 
				setAhead( nah);														// <-- Roboter bekommt den Befehl 200 Steps zu fahren
				setTurnLeft(20-e.getBearing());										// <-- Der Roboter dreht 20 Grad minus den Winkel zum Gegner nach links 
				setFire(Math.min(2.2,getEnergy()/10));  							// <-- Roboter schießt. Die Stärke der Kugeln kommt auf die Lebensenergie des Roboters an
			}     
	
		} 
	    setTurnRadarLeft(getRadarTurnRemaining());  								// <-- infinity lock
		
  }	
}
// ---------------------------------------- ENDE ON SCANNED ROBOT ------------------------------------------------------------------------------------------
// ------------------------------------------------- Roboter berührt einen anderen Roboter ------------------------------------------------------------------
   	public void onHitRobot(HitRobotEvent event) 
	{		
			if (event.getName() .equals("ss2010.Mafia.Escobar") ) 							// <-- Wenn der Roboter Escobarr berührt, dann fährt der Roboter weg
			{
				if (event.getBearing() > -90 && event.getBearing() <= 90) 			// <-- Es wird geprüft wo der Einschlag war
				{   
          			setBack(200);                      								// <-- Roboter fährt 100 Steps zurück
       				} 
			
				else 
				{
           			setAhead(200);                       							// <-- Roboter fährt 100 Steps nach vorne 
       				}
			}
			// <-- Gegner angreifen
			else 
			{			
				setTurnRadarLeft(getRadarTurnRemaining());                			// <-- infinity lock 
				kanone = robocode.util.Utils.normalRelativeAngle(event.getBearing() + getHeading() - getGunHeading());	// <-- Auf den Gegner schauen Samplebot Fire
				turnGunRight(kanone);											// <-- Kanone auf Gegner drehen
				fire(3);															// <-- Roboter schießt auf Gegner mit voller Kraft
          	}
			
			if (event.getBearing() > -90 && event.getBearing() <= 90) 				// <-- Es wird geprüft wo der Einschlag war
			{   
          		setBack(100);                      									// <-- Roboter fährt 100 Steps zurück
       		} 
			
			else 
			{
           		setAhead(100);                       								// <-- Roboter fährt 100 Steps nach vorne 
       		}
   }		

	public void onHitByBullet(HitByBulletEvent e) {
		if(e.getName() .equals( "ss2010.Mafia.Escobar" ))									// <-- Es wir geprüft ob wir von Escobarr abgeschossen wurden
		{ 
			setAhead(300);															// <-- Der Roboter fährt 300 Steps vor
			setTurnLeft(90 - e.getBearing());										// <-- Der Roboter dreht um 90 Grad von Escobarr weg
		}
	}
}
																																																																																																																																								
																																																																																																																																								
