package ss2010.ng;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.Utils;

public class Nurra extends TeamRobot {
	

//Variablen Deklaration
boolean movingForward;
public String Feindname;
public String name;
public String name2;
int zähle=0;

	//Standartverhalten
	public void run (){
		
		//Färben des Roboters
		setBodyColor(Color.blue); //färbt den Unterbau blau
		setGunColor(Color.yellow); //färbt die Kanone gelb
		setRadarColor(Color.pink); //färbt das Radar pink
		
		// sowohl die Kanone als auch das Radar, sollen sich unabhängig vom unteren Teil drehen können
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		// setzen die Geschwindigeit auf das Maximum
		setMaxVelocity(8);
		
		//Bewegungsmuster, wenn kein feindlicher Roboter in Sicht
		do {
	        setAhead(100);
	        turnRadarRight(360);
	        setTurnLeft(180);
	        turnRadarLeft(360);
	        setBack(100);
	        turnRadarRight(360);
	    } while (true);		
	}
	
	
	//Verhalten, wenn ein anderer Roboter gescannt wird
	public void onScannedRobot(ScannedRobotEvent e){
		
		//Deklaration der Variablen
		name=e.getName();
		double BulletPower = Math.min(3.0,getEnergy()); 
		double myX = getX();
		double myY = getY();
		double headingRadians = getHeadingRadians();
		double EnemyBearingRadians = e.getBearingRadians();
		double Distance = e.getDistance();
		double absoluteBearing = headingRadians + EnemyBearingRadians;
		double enemyX = getX() + Distance * Math.sin(absoluteBearing);
		double enemyY = getY() + Distance * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
		double battleFieldHeight = getBattleFieldHeight(); 
	    double battleFieldWidth = getBattleFieldWidth();
		
		
	    //Teampartner sollen sich nicht absichtlich gegenseitig beschießen
		if(isTeammate(e.getName())){
			return;
			}	
		
		
		//Bewegungsmethode unseres Roboters, während eines Angriffs --> entweder Oszillator Movement oder lineares Movement
		//Hat der Roboter eine Nachricht von seinem Teampartner erhalten, so soll er das lineare Movement benutzen
		//Außerdem soll er den Feind, dessen Namen er erhalten hat, suchen
		if(Feindname != null){
			if(!Feindname.equals(name)){return;}
			else{linearMovement(EnemyBearingRadians,Distance);
				}
		}
		else{
			//im Normalfall benutzt er das Oszillator Movement
			if(zähle<3){
				movementOszillator(200, EnemyBearingRadians, Distance);
				}				
			//schießt er allerdings drei mal oder öfters daneben, so soll er in die lineare Bewegung übergehen
			if (zähle>=3){
				linearMovement(EnemyBearingRadians,Distance);	}
			}
			
			
			//Zielvorgang unseres Roboters --> Lineares Targeting
			double deltaTime = 0;
			
			//Schleife, um den Schnittpunkt zu erfassen
			double predictedX = enemyX, predictedY = enemyY;
			while((++deltaTime) * (20.0 - 3.0 * BulletPower) < 
					Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
				//neue Koordinatenberechnung
				predictedX += Math.sin(enemyHeading) * enemyVelocity;	
				predictedY += Math.cos(enemyHeading) * enemyVelocity;
				//um preziser zu zielen
				if(	predictedX < 18.0 
					|| predictedY < 18.0
					|| predictedX > battleFieldWidth - 18.0
					|| predictedY > battleFieldHeight - 18.0){
					predictedX = Math.min(Math.max(18.0, predictedX), 
			                    battleFieldWidth - 18.0);	
					predictedY = Math.min(Math.max(18.0, predictedY), 
			                    battleFieldHeight - 18.0);
					break;
				}
			}
			
			
			//Berechnung des Winkels zwischen den beiden feindlichen Koordinaten
			double theta = Utils.normalAbsoluteAngle(Math.atan2(
			    predictedX - getX(), predictedY - getY()));

			//Radar wird auf den Feind ausgerichtet
			setTurnRadarRightRadians(
			    Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
			
			//Kanonen wird auf den Feind ausgerichtet
			setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
			//Und dann...
			fire(BulletPower);//Feuer frei!!
		
	}
	
	
	
	//Stößt unser Roboter mit einem anderen zusammen, so soll er sich in die entgegengesetzte Richtung bewegen
	public void onHitRobot(HitRobotEvent e){
				if (e.isMyFault()){
			Richtungswechsel();
			}
		}
	
	
	//Stößt unser Roboter an die Wand, so soll er sich in die entgegengesetzte Richtung bewegen
	public void onHitWall(HitWallEvent e){
		Richtungswechsel();
	}
	
	
	//Der Roboter soll zählen, wie oft er daneben schießt, denn je nach dem verändert er sein Bewegungsverhalten
	public void onBulletMissed(BulletMissedEvent event){
		if(name==name2){ 
			zähle++;
		}
		else{
			zähle=0;
			name2=name;
		}
	}
	
	//erhält er eine Nachricht, bzw. den Namen des Feindes, so soll er diesen bekämpfen
	public void onMessageReceived(MessageEvent event) {
		Feindname=(String) event.getMessage();
	      
	   }
	//ist sein Gegner tot, so soll er dies registrieren und nach anderen Robotern weiter scannen
	public void onRobotDeath(RobotDeathEvent e){
		if(Feindname != null){
			if(Feindname.equals(name)){Feindname=null;}
		}
		if(name2.equals(name)){zähle=0;}
	}
	
	//Bewegungsmethode --> Richtungswechsel
	public void Richtungswechsel(){
		if(movingForward){
			setBack(400);
			movingForward=false;
		}
		else{
			setAhead(400);
			movingForward=true;
		}
	}
	
	//Bewegungsmethode --> Oszillator Movement
	public void movementOszillator(int n, double EnemyBearingRadians, double Distance){
		int a=12;
		int b = 7;
		if (getDistanceRemaining() == 0) {setAhead(n * Math.sin(getTime() / a) * Math.cos(getTime() / b)); }
			setTurnRightRadians(EnemyBearingRadians + Math.PI/2 - 0.5236 * (Distance > n ? 1 : -1));
	}
	
	//Bewegungsmethode --> lineares Movement
	public void linearMovement(double EnemyBearingRadians, double Distance){
		double normalBearing=Utils.normalRelativeAngle(EnemyBearingRadians);
		setTurnRight(normalBearing);
		if(Distance<100){setBack(100);}
		else{setAhead(Distance-100);}
	}
	

	
	
	
	
	

}
